-- 修改为你的库名
USE HINA_CLOUD;

-- 为避免外键阻塞/校验失败，先关闭检查（仅当前会话）
SET @orig_fk_check := @@FOREIGN_KEY_CHECKS;
SET FOREIGN_KEY_CHECKS = 0;

-- 一、原子交换：把备份表换回正式名；把现有“出问题”的表收纳到 *_bad_20251027 做证据保留
RENAME TABLE
  T_BASE_DICT              TO T_BASE_DICT_bad_20251027,
  T_BASE_DICT_bak_20251027 TO T_BASE_DICT,

  T_DATA_PROJECT_USER              TO T_DATA_PROJECT_USER_bad_20251027,
  T_DATA_PROJECT_USER_bak_20251027 TO T_DATA_PROJECT_USER,

  T_DATA_ABM_EXPERIMENT              TO T_DATA_ABM_EXPERIMENT_bad_20251027,
  T_DATA_ABM_EXPERIMENT_bak_20251027 TO T_DATA_ABM_EXPERIMENT,

  T_BASE_MENU              TO T_BASE_MENU_bad_20251027,
  T_BASE_MENU_bak_20251027 TO T_BASE_MENU,

  T_DATA_SUPPLIER_ATTRI              TO T_DATA_SUPPLIER_ATTRI_bad_20251027,
  T_DATA_SUPPLIER_ATTRI_bak_20251027 TO T_DATA_SUPPLIER_ATTRI;

-- 二、删除本次“新建”的表（若不存在则忽略）
DROP TABLE IF EXISTS
  T_DATA_PROJECT_ROLE_MENU,
  T_DATA_PROJECT_ROLE;

-- 三、恢复外键检查到原值
SET FOREIGN_KEY_CHECKS = @orig_fk_check;

-- 四、自检（行数快速校验，可选执行）
-- SELECT 'T_BASE_DICT' t, COUNT(*) FROM T_BASE_DICT
-- UNION ALL SELECT 'T_DATA_PROJECT_USER', COUNT(*) FROM T_DATA_PROJECT_USER
-- UNION ALL SELECT 'T_DATA_ABM_EXPERIMENT', COUNT(*) FROM T_DATA_ABM_EXPERIMENT
-- UNION ALL SELECT 'T_BASE_MENU', COUNT(*) FROM T_BASE_MENU
-- UNION ALL SELECT 'T_DATA_SUPPLIER_ATTRI', COUNT(*) FROM T_DATA_SUPPLIER_ATTRI;

-- SHOW CREATE TABLE T_BASE_DICT\G
-- SHOW CREATE TABLE T_BASE_MENU\G
