
USE HINA_CLOUD;

ALTER TABLE `T_BASE_DICT` MODIFY COLUMN `DICT_KEY` varchar(128) NULL DEFAULT NULL COMMENT '字典值' AFTER `CODE`;
UPDATE `T_BASE_DICT` SET DICT_KEY = 'INT,DECIMAL,BIGINT,DOUBLE,FLOAT,LARGEINT,SMALLINT,TINYINT,VALUE_NUM' WHERE CODE = 'data_type_group' AND DICT_VALUE = 'filter_int';
UPDATE `T_BASE_DICT` SET DICT_KEY = 'CHAR,VARCHAR,STRING,VALUE_STR' WHERE CODE = 'data_type_group' AND DICT_VALUE = 'filter_text';
UPDATE `T_BASE_DICT` SET DICT_KEY = 'DATE,DATETIME,VALUE_TM' WHERE CODE = 'data_type_group' AND DICT_VALUE = 'filter_time';
UPDATE `T_BASE_DICT` SET DICT_KEY = 'BOOLEAN,BOOL,VALUE_BOOL' WHERE CODE = 'data_type_group' AND DICT_VALUE = 'filter_boolean';


ALTER TABLE `T_DATA_PROJECT_USER`
MODIFY COLUMN `PROJECT_ROLE` varchar(64) DEFAULT NULL COMMENT '项目角色' AFTER `PROJECT_CODE`,
ADD COLUMN `DATA_PERMISSION` varchar(64) DEFAULT NULL COMMENT '数据权限' AFTER `PROJECT_ROLE`;

## AB测试试验表 新增字段
ALTER TABLE `T_DATA_ABM_EXPERIMENT`
    ADD COLUMN `IS_CREATE_TAG` int(2) DEFAULT '0' COMMENT '是否生成标签：否：0, 是:1' AFTER `RELEASE_METHOD`,
    ADD COLUMN `TAG_ID` bigint(20) DEFAULT NULL COMMENT '标签ID（选择生成标签且在试验上线后才有）' AFTER `IS_CREATE_TAG`,
    ADD COLUMN `TAG_KEEP_TYPE` VARCHAR(16) DEFAULT NULL COMMENT '标签保留类型：永久 PERMANENT，自定义 DEFINE ' AFTER `TAG_ID`,
    ADD COLUMN `TAG_KEEP_PERIOD` int(2) DEFAULT NULL COMMENT '标签保留期限（试验结束后保留的天数）' AFTER `TAG_KEEP_TYPE`;



CREATE TABLE `T_DATA_PROJECT_DATA_PERMISSION` (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `TENANT_ID` varchar(16) NOT NULL DEFAULT 'h000000' COMMENT '租户ID',
  `PROJECT_CODE` varchar(32) NOT NULL COMMENT '项目编码',
  `PERMISSION_CODE` varchar(64) NOT NULL COMMENT '数据权限编码',
  `PERMISSION_NAME` varchar(64) NOT NULL COMMENT '数据权限名称',
  `PERMISSION_RULE` longtext COMMENT '数据权限规则',
  `IS_DELETED` int(2) DEFAULT '0' COMMENT '是否已删除 0:未删除, 1:已删除',
  `CREATE_USER` bigint(20) DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime DEFAULT NULL COMMENT '创建时间',
  `UPDATE_USER` bigint(20) DEFAULT NULL COMMENT '修改人',
  `UPDATE_TIME` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='项目数据权限表';

CREATE TABLE `T_DATA_PROJECT_ROLE` (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `TENANT_ID` varchar(16) NOT NULL DEFAULT 'h000000' COMMENT '租户ID',
  `PROJECT_CODE` varchar(32) NOT NULL COMMENT '项目编码',
  `PROJECT_ROLE` varchar(64) NOT NULL COMMENT '项目角色编码，角色编码自定义',
  `PROJECT_ROLE_NAME` varchar(64) NOT NULL COMMENT '项目角色名称',
  `IS_DELETED` int(2) DEFAULT '0' COMMENT '是否已删除 0:未删除, 1:已删除',
  `CREATE_USER` bigint(20) DEFAULT NULL COMMENT '创建人',
  `CREATE_TIME` datetime DEFAULT NULL COMMENT '创建时间',
  `UPDATE_USER` bigint(20) DEFAULT NULL COMMENT '修改人',
  `UPDATE_TIME` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='项目角色表';

CREATE TABLE `T_DATA_PROJECT_ROLE_MENU` (
  `ID` bigint(20) NOT NULL COMMENT '主键',
  `MENU_ID` bigint(20) DEFAULT NULL COMMENT '菜单ID',
  `ROLE_ID` bigint(20) DEFAULT NULL COMMENT '角色ID',
  `IS_DELETED` int(2) DEFAULT '0' COMMENT '是否已删除',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='项目角色菜单表';


CREATE TABLE `T_DATA_ABM_EXPERIMENT_OPERATION` (
`ID` bigint(20) NOT NULL COMMENT '主键',
`EXPERIMENT_ID` bigint(20) NOT NULL COMMENT '试验ID',
`OPERATION` varchar(128) DEFAULT NULL COMMENT '操作记录',
`CONFIG_UPDATE_TYPE` varchar(16) DEFAULT 'NONE' COMMENT '配置更新类型:NONE 无配置更新，EXPERIMENT 试验配置变更，RELEASE 发布变更',
`CONFIG_INFO` varchar(3096) DEFAULT NULL COMMENT '配置信息json',
`IS_DELETED` tinyint(2) DEFAULT '0' COMMENT '是否已删除 0:未删除, 1:已删除',
`CREATE_USER` bigint(20) DEFAULT NULL COMMENT '创建人',
`CREATE_TIME` datetime DEFAULT NULL COMMENT '创建时间',
`UPDATE_USER` bigint(20) DEFAULT NULL COMMENT '修改人',
`UPDATE_TIME` datetime DEFAULT NULL COMMENT '修改时间',
PRIMARY KEY (`ID`),
KEY `INDEX_TIME` (`CREATE_TIME`) USING BTREE
) ENGINE = InnoDB DEFAULT CHARSET = utf8mb4 COMMENT = '试验操作记录表';



-- ## 嗨数业务初始化数据 ## --

INSERT INTO `T_DATA_PROJECT_ROLE` (`ID`, `TENANT_ID`, `PROJECT_CODE`, `PROJECT_ROLE`, `PROJECT_ROLE_NAME`, `IS_DELETED`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1, 'h000000', '', 'admin', '管理员', 0, NULL, NULL, NULL, NULL);
INSERT INTO `T_DATA_PROJECT_ROLE` (`ID`, `TENANT_ID`, `PROJECT_CODE`, `PROJECT_ROLE`, `PROJECT_ROLE_NAME`, `IS_DELETED`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (2, 'h000000', '', 'analyst', '分析师', 0, NULL, NULL, NULL, NULL);
INSERT INTO `T_DATA_PROJECT_ROLE` (`ID`, `TENANT_ID`, `PROJECT_CODE`, `PROJECT_ROLE`, `PROJECT_ROLE_NAME`, `IS_DELETED`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (3, 'h000000', '', 'user', '普通用户', 0, NULL, NULL, NULL, NULL);




INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1858710175494569986, 1547495064446439426, 'feature_type', 'VALUE_JSON', '对象', 6, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1854355036718219266, 1547495064446439426, 'feature_type', 'VALUE_ARRAY', '列表', 5, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1854349969587945474, 1546326642417848321, 'create_source', 'prefer_measures', '偏好标签', 17, NULL, 0);





INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1876093768010268673, 1554273742688432129, 'mcenter_project_analysis_view', '查看', 'mcenter_project_analysis_view', '/mcenter/project/analysis/view', NULL, 1, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-01-06 10:29:45', 1628939406275825665, '2025-01-06 10:29:45');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1876093674737336322, 1864864244575449090, 'mcenter_project_role_view', '查看', 'mcenter_project_role_view', '/mcenter/project/role/view', NULL, 1, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-01-06 10:29:23', 1628939406275825665, '2025-01-06 10:29:23');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1876093543954743298, 1866386951730212865, 'mcenter_project_permission_view', '查看', 'mcenter_project_permission_view', '/mcenter/project/permission/view', NULL, 1, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-01-06 10:28:52', 1628939406275825665, '2025-01-06 10:28:52');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1866387161214726145, 1866386951730212865, 'mcenter_project_permission_edit', '编辑', 'mcenter_project_permission_edit', '/mcenter/project/permission/edit', NULL, 2, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2024-12-10 15:39:10', 1628939406275825665, '2025-01-06 10:30:24');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1866386951730212865, 1554240708886999041, 'mcenter_project_permission', '数据权限', 'mcenter_project_permission', '/mcenter/project/permission', NULL, 4, 2, 1, 0, 0, NULL, 0, 1, 1628939406275825665, '2024-12-10 15:38:20', 1628939406275825665, '2024-12-10 15:38:20');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1864866631725821954, 1864864244575449090, 'mcenter_project_role_edit', '编辑', 'mcenter_project_role_edit', '/mcenter/project/role/edit', NULL, 2, 2, 2, 0, 0, NULL, 0, 1, 1638417220113051649, '2024-12-06 10:57:07', 1628939406275825665, '2025-01-06 10:30:06');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1864864244575449090, 1554240708886999041, 'mcenter_project_role', '角色管理', 'mcenter_project_role', '/mcenter/project/role', NULL, 3, 2, 1, 0, 0, NULL, 0, 1, 1638417220113051649, '2024-12-06 10:47:38', 1638417220113051649, '2024-12-06 10:47:38');



INSERT INTO `T_DATA_SUPPLIER_ATTRI` (`SUPPLIER`, `REPORT_NAME`, `REPORT_CNAME`, `REPORT_EVENT`, `REPORT_EVENT_CNAME`, `REPORT_EVENT_ATTR`, `REPORT_ATTR_NAME`, `REPORT_DATA_ATTR`, `REPORT_ATTR_DATA_TYPE`, `REPORT_ATTR_CNAME`, `IS_REQ_ATTR`, `IS_DELETED`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'userId', 'userid', 'BIGINT', '账户id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'solutionType', 'solutiontype', 'VARCHAR', '线索类型', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'cluePhoneNumber', 'cluephonenumber', 'VARCHAR', '用户联系方式', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'commitTime', 'committime', 'VARCHAR', '线索时间', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'clueId', 'clueid', 'VARCHAR', '线索id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'flowChannelName', 'flowchannelname', 'VARCHAR', '流量渠道', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'area', 'area', 'VARCHAR', '线索地域', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'connect', 'connect', 'BIGINT', '通话状态，电话/回呼组件特有(0未接通，1接通)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'formDetail', 'formdetail', 'VARCHAR', '抽奖/卡券/表单组件才有', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'imName', 'imname', 'VARCHAR', '咨询组件的工具名称,枚举值', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'clueUserMsgCount', 'clueusermsgcount', 'BIGINT', '用户消息数(咨询组件特有)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'humanServiceMsgCount', 'humanservicemsgcount', 'BIGINT', '人工客服消息数(咨询组件特有)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'aiServiceMessageNum', 'aiservicemessagenum', 'BIGINT', '智能客服消息数(咨询组件特有)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'ip', 'ip', 'VARCHAR', '访问地址ip', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'campaignId', 'campaignid', 'BIGINT', '计划id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'adgroupId', 'adgroupid', 'BIGINT', '单元id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'creativeId', 'creativeid', 'BIGINT', '创意id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'keywordId', 'keywordid', 'BIGINT', '关键词id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'searchWord', 'searchword', 'VARCHAR', '搜索词', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'siteId', 'siteid', 'BIGINT', '站点id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'pageId', 'pageid', 'BIGINT', '页面id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'url', 'url', 'VARCHAR', '页面URL，咨询线索暂无该字段', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'bdVid', 'bdvid', 'VARCHAR', '转化追踪id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'solutionId', 'solutionid', 'BIGINT', '组件方案id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'solutionName', 'solutionname', 'VARCHAR', '组件方案名称', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'consultUrl', 'consulturl', 'VARCHAR', '咨询URL', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'callDuration', 'callduration', 'BIGINT', '通话时长', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'userName', 'username', 'VARCHAR', 'C端用户名称', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'solutionRefTypeName', 'solutionreftypename', 'VARCHAR', '网名行为标志(微信复制/调起,粉丝关注/查看)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'accountName', 'accountname', 'VARCHAR', '账号名称(微信号、粉丝关注账号)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'creativeName', 'creativename', 'VARCHAR', '所属创意', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'userAgent', 'useragent', 'VARCHAR', '网民UA', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'showTypeName', 'showtypename', 'VARCHAR', '来源类型(H5站点,PC站点,小程序站点,高级创意,搜索高级创意)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'keyword', 'keyword', 'VARCHAR', '关键词', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'campaignName', 'campaignname', 'VARCHAR', '所属计划', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'adgroupName', 'adgroupname', 'VARCHAR', '所属单元', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'siteName', 'sitename', 'VARCHAR', '站点名称', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'siteUrl', 'siteurl', 'VARCHAR', '站点URL', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'pageName', 'pagename', 'VARCHAR', '页面名称', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'returnCallUrl', 'returncallurl', 'VARCHAR', '聆音回访链接', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'refundSupportive', 'refundsupportive', 'VARCHAR', '是否参与赔付(参与赔付, 不参与赔付,待定)', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'refundViewUrl', 'refundviewurl', 'VARCHAR', '返款视图链接', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'subShopId', 'subshopid', 'BIGINT', '门店id', NULL, 0, NULL, now(), NULL, now()),
('BAIDU', NULL, NULL, 'H_bd_market_data', '百度线索推送', 'H_bd_market_get_data', 'wechatAccount', 'wechataccount', 'VARCHAR', '微信账号', NULL, 0, NULL, now(), NULL, now());





UPDATE `T_BASE_MENU` 
SET `PARENT_ID` = 1557615886414290946
WHERE `ID` = 1876093768010268673;

UPDATE `T_BASE_MENU` 
SET `PARENT_ID` = 1557613986625265666
WHERE `ID` = 1866386951730212865;


UPDATE `T_BASE_MENU` 
SET `PARENT_ID` = 1557613986625265666
WHERE `ID` = 1864864244575449090;




INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281994421383170, 1844281746198278145, 'filter_object', 'jsonIsNull', '无值', 6, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281950356025346, 1844281746198278145, 'filter_object', 'jsonNotNull', '有值', 5, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281901664350210, 1844281746198278145, 'filter_object', 'jsonNotEmpty', '不为空', 4, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281862976090113, 1844281746198278145, 'filter_object', 'jsonIsEmpty', '为空', 3, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281827966234626, 1844281746198278145, 'filter_object', 'notRegexMatch', '正则不匹配', 2, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281793979789314, 1844281746198278145, 'filter_object', 'regexMatch', '正则匹配', 1, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281746198278145, 0, 'filter_object', 'top', '筛选算子（对象型）', 5, NULL, 0);

INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281663281082369, 1844279681006874625, 'filter_array', 'arrayIsNull', '无值', 9, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281621019275265, 1844279681006874625, 'filter_array', 'arrayNotNull', '有值', 8, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281448281059330, 1844279681006874625, 'filter_array', 'arrayNotEmpty', '不为空', 7, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281355725352962, 1844279681006874625, 'filter_array', 'arrayIsEmpty', '为空', 6, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281314130440194, 1844279681006874625, 'filter_array', 'arrayNotRegexMatch', '正则不匹配', 5, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281275140190210, 1844279681006874625, 'filter_array', 'arrayRegexMatch', '正则匹配', 4, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281238997872642, 1844279681006874625, 'filter_array', 'arrayPosition', '元素位置', 3, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281204365504514, 1844279681006874625, 'filter_array', 'arrayNotContains', '不存在元素', 2, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844281160400809985, 1844279681006874625, 'filter_array', 'arrayContains', '存在元素', 1, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844279681006874625, 0, 'filter_array', 'top', '筛选算子（列表型）', 5, NULL, 0);

INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844279167028473858, 1547120037059465218, 'data_type_group', 'JSON,VALUE_JSON', 'filter_object', 6, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1844279073709404162, 1547120037059465218, 'data_type_group', 'ARRAY,VALUE_ARRAY', 'filter_array', 5, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1843940033416855554, 1539437894623154178, 'doris_field_type', 'JSON', '对象|JSON', 18, NULL, 0);
INSERT INTO `T_BASE_DICT` (`ID`, `PARENT_ID`, `CODE`, `DICT_KEY`, `DICT_VALUE`, `SORT`, `REMARK`, `IS_DELETED`) VALUES (1843939896481218561, 1539437894623154178, 'doris_field_type', 'ARRAY', '列表|ARRAY', 17, NULL, 0);



-- 项目角色菜单初始化
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021211, 15576135869458004, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021212, 15576135869458005, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021213, 15576135869458006, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021214, 1554233557091168257, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021215, 15576129373824001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021216, 15576129373824002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021217, 15576129373824003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021218, 1639105298168655874, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021219, 1641418688198291457, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021220, 1641418990636969985, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021221, 1554224544874049538, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021222, 15576087210708001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021223, 15576087210708002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021224, 15576087210708003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021225, 15576087210708004, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021226, 15576087210708005, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021227, 15576087210708006, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021228, 1629022747576467457, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021229, 1629031323380449282, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021230, 1633722189097435137, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021231, 1685968424406478849, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593357021232, 1793241041722150913, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215489, 1554226280560930818, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215490, 1600057648531558402, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215491, 1620328512271466498, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215492, 1620328684518948865, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215493, 1600058140120764418, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215494, 1620328951964549121, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215495, 1620329144806064129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215496, 1600058257758408705, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215497, 1620329329145724929, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215498, 1620329482996989953, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215499, 1600058462134259714, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215500, 1620329663956041729, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215501, 1620329794809937922, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215502, 1600058579352473602, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215503, 1620330098901172226, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215504, 1620330256967712769, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215505, 1600058702514016257, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215506, 1620330432306397185, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215507, 1620330699257069570, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215508, 1600058979342274561, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215509, 1620333389202636802, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215510, 1620333552847601666, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215511, 1729329368600252417, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215512, 1600061341825945602, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215513, 1620327814318309378, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215514, 1620328316301000705, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215515, 1627571444025573378, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215516, 1627572625179328513, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215517, 1627572813553909762, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215518, 1633020625067814913, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215519, 1678333024722952193, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215520, 1678333660910788609, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215521, 1678333965740220417, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215522, 1685912853204561921, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215523, 1685913694724550657, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215524, 1685913856968617986, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215525, 1728972829536391169, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215526, 1728973108415664129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215527, 1728973506421559297, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215528, 1728977623852355585, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215529, 1778690586094120961, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215530, 1783428642547417089, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215531, 1783428840254324737, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215532, 1554227036684890114, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215533, 1557612193283481602, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215534, 15576121932834001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215535, 15576121932834002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215536, 15576121932834003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215537, 1635527858605457409, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215538, 1557612291061186561, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215539, 15576122910611001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215540, 15576122910611002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215541, 15576122910611003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215542, 1635528567556079618, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215543, 1620974828665237505, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215544, 1621080605480513537, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215545, 1621081021710659585, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215546, 1621081282936107010, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215547, 1621082476765048834, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215548, 1657948000338096129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215549, 1657948824200065026, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215550, 1657950852829720578, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215551, 1632651893095985154, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215552, 1632652754874462210, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215553, 1554240708886999041, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215554, 1554240842257477633, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215555, 1554240983957843970, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215556, 15576156596954002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215557, 1554273742688432129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215558, 15576158864142002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215559, 1876093768010268673, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215560, 1864864244575449090, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215561, 1864866631725821954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215562, 1876093674737336322, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215563, 1866386951730212865, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215564, 1866387161214726145, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215565, 1876093543954743298, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215566, 1629031896460787713, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215567, 1592372495585550337, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215568, 1592354669734830081, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215569, 1592355012745011201, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215570, 1592355164612370434, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215571, 1644151818127773697, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215572, 1644152263072124930, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215573, 1647882361066618882, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215574, 1647882570567909378, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215575, 1647882841872269314, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215576, 1647883149218283521, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215577, 1647883369977085954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215578, 1647883552118931458, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215579, 1647883738710933506, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215580, 1647883963638874113, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215581, 1647884635088224258, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215582, 1647884867981148161, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215583, 1647885305027624961, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215584, 1647885537685667841, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215585, 1656137753452814338, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215586, 1592484757415567361, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215587, 1647885961532669954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215588, 1647886169268158465, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215589, 1647886315917803522, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215590, 1647924988075966465, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215591, 1656171112736432130, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215592, 1663802909148680194, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215593, 1668083655622393857, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215594, 1668084441202950145, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215595, 1668088310268035073, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215596, 1592818395294375937, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215597, 1647886715530117122, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215598, 1647888501393457154, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215599, 1647889654827057154, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215600, 1656497398461702145, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215601, 1656497771016560642, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215602, 1629032889932021762, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215603, 1629033291196891138, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215604, 1647858070938689538, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215605, 1647858342301769730, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215606, 1647858491296030721, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215607, 1647865366641090562, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215608, 1647865649307820034, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215609, 1647865801716244481, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215610, 1647866021464219649, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215611, 1647876389781188610, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215612, 1656136172477030401, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215613, 1639095248549163009, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215614, 1639099236644401153, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215615, 1656135604782178305, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215616, 1639100469786554369, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215617, 1656135907690618881, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215618, 1760841576980066306, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215619, 1760842611945549825, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215620, 1760845047821152258, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215621, 1787360692727955458, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215622, 1787360846054932481, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215623, 1760846449347833857, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215624, 1760846655938277377, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215625, 1760844729574141954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215626, 1760847029835313153, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215627, 1787360185120702466, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215628, 1787360353471676418, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215629, 1860955244722229249, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215630, 1810509711025094657, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215631, 1810510079142379521, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215632, 1810510335720538113, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215633, 1810510458080968705, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876094593361215634, 1810510582676963330, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975426, 15576130784577001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975427, 1552566981953777666, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975428, 15576132006337001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975429, 15576133945153001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975430, 1610088053394952194, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975431, 1610089234561290242, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975432, 15576134804986001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975433, 15576134804986004, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975434, 15576134804986005, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975435, 15576135869458004, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975436, 15576135869458005, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975437, 15576129373824001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975438, 15576129373824002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975439, 1639105298168655874, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975440, 1641418688198291457, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975441, 1641418990636969985, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975442, 15576087210708001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975443, 15576087210708002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975444, 15576087210708003, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975445, 15576087210708006, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975446, 1629022747576467457, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975447, 1629031323380449282, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975448, 1633722189097435137, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975449, 1685968424406478849, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975450, 1793241041722150913, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975451, 1620328684518948865, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975452, 1620329144806064129, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975453, 1620329482996989953, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975454, 1620329794809937922, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975455, 1620330256967712769, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975456, 1620330699257069570, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975457, 1620333389202636802, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975458, 1620333552847601666, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975459, 1620328316301000705, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975460, 1627572813553909762, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975461, 1633020625067814913, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975462, 1678333965740220417, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975463, 1685912853204561921, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975464, 1685913694724550657, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975465, 1685913856968617986, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975466, 1728973506421559297, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975467, 1728977623852355585, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975468, 1783428840254324737, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975469, 15576121932834001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975470, 15576121932834002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975471, 1635527858605457409, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975472, 15576122910611001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975473, 15576122910611002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975474, 1635528567556079618, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975475, 1621080605480513537, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975476, 1621081021710659585, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975477, 1621082476765048834, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975478, 1657948824200065026, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975479, 1657950852829720578, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975480, 1632651893095985154, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975481, 1632652754874462210, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975482, 1876093768010268673, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975483, 1592355164612370434, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975484, 1647883149218283521, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975485, 1656137753452814338, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975486, 1656171112736432130, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975487, 1668083655622393857, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975488, 1656497398461702145, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975489, 1656497771016560642, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975490, 1656136172477030401, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975491, 1639095248549163009, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975492, 1639099236644401153, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975493, 1656135604782178305, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975494, 1639100469786554369, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975495, 1656135907690618881, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975496, 1787360692727955458, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975497, 1760846449347833857, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975498, 1760846655938277377, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975499, 1787360185120702466, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975500, 1552566291558756353, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975501, 1552566621889556481, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975502, 1552566808938737666, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975503, 1554229217026715650, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975504, 1554229402020687873, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975505, 1554229774357442562, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975506, 1554232410473312257, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975507, 1554233557091168257, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975508, 1554224544874049538, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975509, 1554226280560930818, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975510, 1600057648531558402, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975511, 1600058140120764418, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975512, 1600058257758408705, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975513, 1600058462134259714, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975514, 1600058579352473602, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975515, 1600058702514016257, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975516, 1600058979342274561, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975517, 1600061341825945602, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975518, 1627571444025573378, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975519, 1678333024722952193, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975520, 1728972829536391169, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975521, 1778690586094120961, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975522, 1554227036684890114, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975523, 1557612193283481602, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975524, 1557612291061186561, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975525, 1620974828665237505, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975526, 1554240708886999041, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975527, 1554273742688432129, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975528, 1629031896460787713, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975529, 1592372495585550337, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975530, 1592354669734830081, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975531, 1592484757415567361, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975532, 1663802909148680194, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975533, 1592818395294375937, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975534, 1629032889932021762, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975535, 1629033291196891138, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975536, 1760841576980066306, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975537, 1760842611945549825, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975538, 1760845047821152258, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975539, 1760844729574141954, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095808383975540, 1760847029835313153, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632002, 15576087210708001, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632003, 15576087210708003, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632004, 1787360692727955458, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632005, 1760846449347833857, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632006, 1760846655938277377, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632007, 1554224544874049538, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632008, 1760841576980066306, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632009, 1760842611945549825, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1876095996997632010, 1760845047821152258, 3, 0);




--
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893845582534488065, 1810510582676963330, 'abtest_trialTargetManage_edit_mine', '我的试验指标-编辑', 'abtest_trialTargetManage_edit_mine', '/abtest/trialTargetManage/edit/mine', NULL, 5, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 10:09:07', 1628939406275825665, '2025-02-24 10:09:07');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893845360555143170, 1810510458080968705, 'abtest_deviceManage_edit_mine', '我的调试设备-编辑', 'abtest_deviceManage_edit_mine', '/abtest/deviceManage/edit/mine', NULL, 4, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 10:08:15', 1628939406275825665, '2025-02-24 10:08:15');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893845172281225218, 1810510335720538113, 'abtest_trialLayerManage_edit_mine', '我的试验层-编辑', 'abtest_trialLayerManage_edit_mine', '/abtest/trialLayerManage/edit/mine', NULL, 5, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 10:07:30', 1628939406275825665, '2025-02-24 10:07:30');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893844926855720961, 1810510079142379521, 'abtest_trialManage_edit_mine', '我的试验-编辑', 'abtest_trialManage_edit_mine', '/abtest/trialManage/edit/mine', NULL, 5, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 10:06:31', 1628939406275825665, '2025-02-24 10:06:31');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893837748107292673, 1810510582676963330, 'abtest_trialTargetManage_delete', '删除', 'abtest_trialTargetManage_delete', '/abtest/trialTargetManage/delete', NULL, 4, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:38:00', 1628939406275825665, '2025-02-24 09:38:00');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893837644537344001, 1810510582676963330, 'abtest_trialTargetManage_copy', '复制', 'abtest_trialTargetManage_copy', '/abtest/trialTargetManage/copy', NULL, 3, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:37:35', 1628939406275825665, '2025-02-24 09:37:35');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893837361262440450, 1810510582676963330, 'abtest_trialTargetManage_edit', '编辑', 'abtest_trialTargetManage_edit', '/abtest/trialTargetManage/edit', NULL, 2, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:36:27', 1628939406275825665, '2025-02-24 09:36:27');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893837234749648897, 1810510582676963330, 'abtest_trialTargetManage_view', '查看', 'abtest_trialTargetManage_view', '/abtest/trialTargetManage/view', NULL, 1, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:35:57', 1628939406275825665, '2025-02-24 09:35:57');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893837116621271041, 1810510458080968705, 'abtest_deviceManage_delete', '删除', 'abtest_deviceManage_delete', '/abtest/deviceManage/delete', NULL, 3, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:35:29', 1628939406275825665, '2025-02-24 09:35:29');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893837020169056257, 1810510458080968705, 'abtest_deviceManage_edit', '编辑', 'abtest_deviceManage_edit', '/abtest/deviceManage/edit', NULL, 2, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:35:06', 1628939406275825665, '2025-02-24 09:35:06');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893836699292217345, 1810510458080968705, 'abtest_deviceManage_view', '查看', 'abtest_deviceManage_view', '/abtest/deviceManage/view', NULL, 1, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:33:50', 1628939406275825665, '2025-02-24 09:33:50');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893836498808680449, 1810510335720538113, 'abtest_trialLayerManage_delete', '删除', 'abtest_trialLayerManage_delete', '/abtest/trialLayerManage/delete', NULL, 4, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:33:02', 1628939406275825665, '2025-02-24 09:33:02');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893836218746613762, 1810510335720538113, 'abtest_trialLayerManage_allocation', '分配流量', 'abtest_trialLayerManage_allocation', '/abtest/trialLayerManage/allocation', NULL, 3, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:31:55', 1628939406275825665, '2025-02-24 09:31:55');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893835972670992385, 1810510335720538113, 'abtest_trialLayerManage_edit', '编辑', 'abtest_trialLayerManage_edit', '/abtest/trialLayerManage/edit', NULL, 2, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:30:56', 1628939406275825665, '2025-02-24 09:30:56');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893835862042030081, 1810510335720538113, 'abtest_trialLayerManage_view', '查看', 'abtest_trialLayerManage_view', '/abtest/trialLayerManage/view', NULL, 1, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:30:30', 1628939406275825665, '2025-02-24 09:30:30');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893835568117788674, 1810510079142379521, 'abtest_trialManage_delete', '删除', 'abtest_trialManage_delete', '/abtest/trialManage/delete', NULL, 4, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:29:20', 1628939406275825665, '2025-02-24 09:29:20');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893835296549187585, 1810510079142379521, 'abtest_trialManage_copy', '复制', 'abtest_trialManage_copy', '/abtest/trialManage/copy', NULL, 3, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:28:15', 1580080618101821441, '2025-02-26 13:45:51');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893835160502743041, 1810510079142379521, 'abtest_trialManage_edit', '编辑', 'abtest_trialManage_edit', '/abtest/trialManage/edit', NULL, 2, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:27:43', 1580080618101821441, '2025-02-26 13:45:28');
INSERT INTO `T_BASE_MENU` (`ID`, `PARENT_ID`, `CODE`, `NAME`, `ALIAS`, `PATH`, `SOURCE`, `SORT`, `PERMISSION_TYPE`, `CATEGORY`, `ACTION`, `IS_OPEN`, `REMARK`, `IS_DELETED`, `STATUS`, `CREATE_USER`, `CREATE_TIME`, `UPDATE_USER`, `UPDATE_TIME`) VALUES (1893835009348415490, 1810510079142379521, 'abtest_trialManage_view', '查看', 'abtest_trialManage_view', '/abtest/trialManage/view', NULL, 1, 2, 2, 0, 0, NULL, 0, 1, 1628939406275825665, '2025-02-24 09:27:07', 1580080618101821441, '2025-02-26 13:46:41');

DELETE FROM `T_DATA_PROJECT_ROLE_MENU` WHERE `ROLE_ID` IN (1, 2, 3);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872578, 15576087210708001, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872579, 15576087210708003, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872580, 1787360692727955458, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872581, 1760846449347833857, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872582, 1760846655938277377, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872583, 1893835009348415490, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872584, 1893835862042030081, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872585, 1893836699292217345, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872586, 1893837234749648897, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872587, 1554224544874049538, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872588, 1760841576980066306, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872589, 1760842611945549825, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872590, 1760845047821152258, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872591, 1810509711025094657, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872592, 1810510079142379521, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872593, 1810510335720538113, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872594, 1810510458080968705, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893838197006872595, 1810510582676963330, 3, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648194, 15576130784577001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648195, 1552566981953777666, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648196, 15576132006337001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648197, 15576133945153001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648198, 1610088053394952194, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648199, 1610089234561290242, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648200, 15576134804986001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648201, 15576134804986004, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648202, 15576134804986005, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648203, 15576135869458004, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648204, 15576135869458005, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648205, 15576129373824001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648206, 15576129373824002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648207, 1639105298168655874, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648208, 1641418688198291457, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648209, 1641418990636969985, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648210, 15576087210708001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648211, 15576087210708002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648212, 15576087210708003, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648213, 15576087210708006, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648214, 1629022747576467457, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648215, 1629031323380449282, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648216, 1633722189097435137, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648217, 1685968424406478849, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648218, 1793241041722150913, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648219, 1620328684518948865, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648220, 1620329144806064129, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648221, 1620329482996989953, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648222, 1620329794809937922, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648223, 1620330256967712769, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648224, 1620330699257069570, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648225, 1620333389202636802, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648226, 1620333552847601666, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648227, 1620328316301000705, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648228, 1627572813553909762, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648229, 1633020625067814913, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648230, 1678333965740220417, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648231, 1685912853204561921, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648232, 1685913694724550657, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648233, 1685913856968617986, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648234, 1728973506421559297, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648235, 1728977623852355585, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648236, 1783428840254324737, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648237, 15576121932834001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648238, 15576121932834002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648239, 1635527858605457409, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648240, 15576122910611001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648241, 15576122910611002, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648242, 1635528567556079618, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648243, 1621080605480513537, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648244, 1621081021710659585, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648245, 1621082476765048834, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648246, 1657948824200065026, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648247, 1657950852829720578, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648248, 1632651893095985154, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648249, 1632652754874462210, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648250, 1876093768010268673, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648251, 1592355164612370434, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648252, 1647883149218283521, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648253, 1656137753452814338, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648254, 1656171112736432130, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648255, 1668083655622393857, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648256, 1656497398461702145, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648257, 1656497771016560642, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648258, 1656136172477030401, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648259, 1639095248549163009, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648260, 1639099236644401153, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648261, 1656135604782178305, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648262, 1639100469786554369, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648263, 1656135907690618881, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648264, 1787360692727955458, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648265, 1760846449347833857, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648266, 1760846655938277377, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648267, 1787360185120702466, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648268, 1893835009348415490, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648269, 1893835296549187585, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648270, 1893844926855720961, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648271, 1893835862042030081, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648272, 1893836218746613762, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648273, 1893845172281225218, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648274, 1893836699292217345, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648275, 1893845360555143170, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648276, 1893837234749648897, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648277, 1893837644537344001, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648278, 1893845582534488065, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648279, 1552566291558756353, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648280, 1552566621889556481, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648281, 1552566808938737666, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648282, 1554229217026715650, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648283, 1554229402020687873, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648284, 1554229774357442562, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648285, 1554232410473312257, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648286, 1554233557091168257, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648287, 1554224544874049538, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648288, 1554226280560930818, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648289, 1600057648531558402, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648290, 1600058140120764418, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648291, 1600058257758408705, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648292, 1600058462134259714, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648293, 1600058579352473602, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648294, 1600058702514016257, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648295, 1600058979342274561, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648296, 1600061341825945602, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648297, 1627571444025573378, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648298, 1678333024722952193, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648299, 1728972829536391169, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648300, 1778690586094120961, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648301, 1554227036684890114, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648302, 1557612193283481602, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648303, 1557612291061186561, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648304, 1620974828665237505, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648305, 1554240708886999041, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648306, 1554273742688432129, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648307, 1629031896460787713, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648308, 1592372495585550337, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648309, 1592354669734830081, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069872648310, 1592484757415567361, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842498, 1663802909148680194, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842499, 1592818395294375937, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842500, 1629032889932021762, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842501, 1629033291196891138, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842502, 1760841576980066306, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842503, 1760842611945549825, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842504, 1760845047821152258, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842505, 1760844729574141954, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842506, 1760847029835313153, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842507, 1810509711025094657, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842508, 1810510079142379521, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842509, 1810510335720538113, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842510, 1810510458080968705, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859069876842511, 1810510582676963330, 2, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430146, 1552566291558756353, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430147, 1552566621889556481, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430148, 1552566808938737666, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430149, 15576130784577001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430150, 15576130784577003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430151, 1552566981953777666, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430152, 15576132006337001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430153, 1554229217026715650, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430154, 1554229402020687873, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430155, 15576133945153001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430156, 15576133945153002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430157, 15576133945153003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430158, 1610088053394952194, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430159, 1610089234561290242, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430160, 1633045089898041345, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430161, 1554229774357442562, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430162, 15576134804986001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430163, 15576134804986002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430164, 15576134804986003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430165, 15576134804986004, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430166, 15576134804986005, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430167, 15576134804986006, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430168, 1554232410473312257, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430169, 15576135869458002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430170, 15576135869458003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430171, 15576135869458004, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430172, 15576135869458005, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430173, 15576135869458006, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430174, 1554233557091168257, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430175, 15576129373824001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430176, 15576129373824002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430177, 15576129373824003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430178, 1639105298168655874, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430179, 1641418688198291457, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430180, 1641418990636969985, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430181, 1554224544874049538, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430182, 15576087210708001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430183, 15576087210708002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430184, 15576087210708003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430185, 15576087210708004, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430186, 15576087210708005, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430187, 15576087210708006, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430188, 1629022747576467457, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430189, 1629031323380449282, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430190, 1633722189097435137, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430191, 1685968424406478849, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430192, 1793241041722150913, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430193, 1554226280560930818, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430194, 1600057648531558402, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430195, 1620328512271466498, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430196, 1620328684518948865, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430197, 1600058140120764418, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430198, 1620328951964549121, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430199, 1620329144806064129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430200, 1600058257758408705, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430201, 1620329329145724929, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430202, 1620329482996989953, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430203, 1600058462134259714, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430204, 1620329663956041729, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430205, 1620329794809937922, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430206, 1600058579352473602, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430207, 1620330098901172226, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430208, 1620330256967712769, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430209, 1600058702514016257, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430210, 1620330432306397185, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430211, 1620330699257069570, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430212, 1600058979342274561, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430213, 1620333389202636802, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430214, 1620333552847601666, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430215, 1729329368600252417, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430216, 1600061341825945602, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430217, 1620327814318309378, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430218, 1620328316301000705, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430219, 1627571444025573378, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430220, 1627572625179328513, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430221, 1627572813553909762, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430222, 1633020625067814913, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430223, 1678333024722952193, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430224, 1678333660910788609, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430225, 1678333965740220417, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430226, 1685912853204561921, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430227, 1685913694724550657, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430228, 1685913856968617986, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430229, 1728972829536391169, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430230, 1728973108415664129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430231, 1728973506421559297, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430232, 1728977623852355585, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430233, 1778690586094120961, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430234, 1783428642547417089, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430235, 1783428840254324737, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430236, 1554227036684890114, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430237, 1557612193283481602, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430238, 15576121932834001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430239, 15576121932834002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430240, 15576121932834003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430241, 1635527858605457409, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430242, 1557612291061186561, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430243, 15576122910611001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430244, 15576122910611002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430245, 15576122910611003, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430246, 1635528567556079618, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430247, 1620974828665237505, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430248, 1621080605480513537, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430249, 1621081021710659585, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430250, 1621081282936107010, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430251, 1621082476765048834, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430252, 1657948000338096129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430253, 1657948824200065026, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430254, 1657950852829720578, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430255, 1632651893095985154, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430256, 1632652754874462210, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430257, 1554240708886999041, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430258, 1554240842257477633, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430259, 1554240983957843970, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430260, 15576156596954002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430261, 1554273742688432129, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430262, 15576158864142002, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430263, 1876093768010268673, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430264, 1864864244575449090, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430265, 1864866631725821954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430266, 1876093674737336322, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430267, 1866386951730212865, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430268, 1866387161214726145, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430269, 1876093543954743298, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430270, 1629031896460787713, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430271, 1592372495585550337, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430272, 1592354669734830081, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430273, 1592355012745011201, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430274, 1592355164612370434, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430275, 1644151818127773697, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430276, 1644152263072124930, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430277, 1647882361066618882, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430278, 1647882570567909378, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430279, 1647882841872269314, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430280, 1647883149218283521, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430281, 1647883369977085954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430282, 1647883552118931458, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430283, 1647883738710933506, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430284, 1647883963638874113, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430285, 1647884635088224258, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430286, 1647884867981148161, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430287, 1647885305027624961, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430288, 1647885537685667841, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430289, 1656137753452814338, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430290, 1592484757415567361, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430291, 1647885961532669954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430292, 1647886169268158465, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430293, 1647886315917803522, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430294, 1647924988075966465, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430295, 1656171112736432130, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430296, 1663802909148680194, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430297, 1668083655622393857, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430298, 1668084441202950145, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430299, 1668088310268035073, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430300, 1592818395294375937, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430301, 1647886715530117122, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430302, 1647888501393457154, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430303, 1647889654827057154, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430304, 1656497398461702145, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430305, 1656497771016560642, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430306, 1629032889932021762, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430307, 1629033291196891138, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430308, 1647858070938689538, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430309, 1647858342301769730, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430310, 1647858491296030721, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430311, 1647865366641090562, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430312, 1647865649307820034, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430313, 1647865801716244481, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430314, 1647866021464219649, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430315, 1647876389781188610, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430316, 1656136172477030401, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430317, 1639095248549163009, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430318, 1639099236644401153, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430319, 1656135604782178305, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430320, 1639100469786554369, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430321, 1656135907690618881, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430322, 1760841576980066306, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430323, 1760842611945549825, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430324, 1760845047821152258, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430325, 1787360692727955458, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430326, 1787360846054932481, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430327, 1760846449347833857, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430328, 1760846655938277377, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430329, 1760844729574141954, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430330, 1760847029835313153, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430331, 1787360185120702466, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430332, 1787360353471676418, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430333, 1860955244722229249, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430334, 1810509711025094657, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430335, 1810510079142379521, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430336, 1893835009348415490, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430337, 1893835160502743041, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430338, 1893835296549187585, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430339, 1893835568117788674, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430340, 1893844926855720961, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430341, 1810510335720538113, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430342, 1893835862042030081, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430343, 1893835972670992385, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430344, 1893836218746613762, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430345, 1893836498808680449, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430346, 1893845172281225218, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430347, 1810510458080968705, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430348, 1893836699292217345, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430349, 1893837020169056257, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430350, 1893837116621271041, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430351, 1893845360555143170, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430352, 1810510582676963330, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430353, 1893837234749648897, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430354, 1893837361262440450, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430355, 1893837644537344001, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430356, 1893837748107292673, 1, 0);
INSERT INTO `T_DATA_PROJECT_ROLE_MENU` (`ID`, `MENU_ID`, `ROLE_ID`, `IS_DELETED`) VALUES (1893859128647430357, 1893845582534488065, 1, 0);


CREATE TABLE `T_BASE_USER_OAUTH_NEW` (
                                         `ID` BIGINT ( 20 ) NOT NULL AUTO_INCREMENT COMMENT '主键',
                                         `UUID` VARCHAR ( 64 ) DEFAULT NULL COMMENT '第三方系统用户ID',
                                         `USER_ID` BIGINT ( 20 ) DEFAULT NULL COMMENT '用户ID',
                                         `USERNAME` VARCHAR ( 32 ) DEFAULT NULL COMMENT '账号',
                                         `NICKNAME` VARCHAR ( 64 ) DEFAULT NULL COMMENT '用户名',
                                         `AVATAR` text COMMENT '头像',
                                         `BLOG` VARCHAR ( 50 ) DEFAULT NULL COMMENT '应用主页',
                                         `COMPANY` VARCHAR ( 255 ) DEFAULT NULL COMMENT '公司名',
                                         `LOCATION` VARCHAR ( 255 ) DEFAULT NULL COMMENT '地址',
                                         `EMAIL` VARCHAR ( 255 ) DEFAULT NULL COMMENT '邮件',
                                         `REMARK` VARCHAR ( 255 ) DEFAULT NULL COMMENT '备注',
                                         `GENDER` VARCHAR ( 16 ) DEFAULT NULL COMMENT '性别',
                                         `SOURCE` VARCHAR ( 16 ) DEFAULT NULL COMMENT '来源',
                                         `STATUS` INT ( 2 ) DEFAULT '1' COMMENT '状态 0：终止, 1:正常',
                                         `CREATE_USER` BIGINT ( 20 ) DEFAULT NULL COMMENT '创建人',
                                         `CREATE_TIME` datetime DEFAULT NULL COMMENT '创建时间',
                                         `UPDATE_USER` BIGINT ( 20 ) DEFAULT NULL COMMENT '修改人',
                                         `UPDATE_TIME` datetime DEFAULT NULL COMMENT '修改时间',
                                         PRIMARY KEY ( `ID` ) USING BTREE,
                                         UNIQUE KEY `UNQ_ID` ( `UUID`, `USER_ID` ) USING BTREE COMMENT '唯一索引'
) ENGINE = INNODB AUTO_INCREMENT = 1 DEFAULT CHARSET = utf8mb4 COMMENT = '用户第三方认证表';